<?php
// controllers/ProductController.php

require_once '../config/database.php';
require_once '../models/Product.php';

class ProductController {
    private $db;
    private $product;

    public function __construct() {
        $database = new Database();
        $this->db = $database->connect();
        $this->product = new Product($this->db);
    }

    // Função para listar todos os produtos
    public function index() {
        $stmt = $this->product->read();
        $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($products);
    }

    // Função para criar um novo produto
    public function store($data) {
        $this->product->title = $data['title'];
        $this->product->price = $data['price'];
        $this->product->site_name = $data['site_name'];
        $this->product->img = $data['img'];
        $this->product->rating = $data['rating'];
        $this->product->link = $data['link'];
        $this->product->contact = $data['contact'];
        $this->product->email = $data['email'];
        $this->product->address = $data['address'];

        if ($this->product->create()) {
            echo json_encode(["message" => "Product created successfully"]);
        } else {
            echo json_encode(["message" => "Failed to create product"]);
        }
    }
}
