<?php
// models/Product.php

class Product {
    private $conn;
    private $table = 'products';

    public $id;
    public $title;
    public $price;
    public $site_name;
    public $img;
    public $rating;
    public $link;
    public $contact;
    public $email;
    public $address;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Método para listar todos os produtos
    public function read() {
        $query = "SELECT * FROM " . $this->table;
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Método para criar um novo produto
    public function create() {
        $query = "INSERT INTO " . $this->table . " SET title=:title, price=:price, site_name=:site_name, img=:img, rating=:rating, link=:link, contact=:contact, email=:email, address=:address";
        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':price', $this->price);
        $stmt->bindParam(':site_name', $this->site_name);
        $stmt->bindParam(':img', $this->img);
        $stmt->bindParam(':rating', $this->rating);
        $stmt->bindParam(':link', $this->link);
        $stmt->bindParam(':contact', $this->contact);
        $stmt->bindParam(':email', $this->email);
        $stmt->bindParam(':address', $this->address);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }
}
