<?php

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type');

// Função para responder com erros ou sucesso
function response($data, $status = 200) {
    http_response_code($status);
    echo json_encode($data);
}

// Roteamento da API
$request = $_SERVER['REQUEST_URI'];
$requestMethod = $_SERVER['REQUEST_METHOD'];

// Roteamento para '/products'
switch ($request) {
    case '/product-api/public/products':
        switch ($requestMethod) {
            case 'GET':
                $products = [
                    [
                        'id' => 1,
                        'title' => 'Puma RS-X',
                        'price' => 399.99,
                        'site_name' => 'Puma',
                        'img' => 'https://artwalk.vtexassets.com/arquivos/ids/436443/39430-2-003-1.jpg?v=638277210260500000',
                        'rating' => 4.5,
                        'link' => 'https://www.puma.com',
                        'contact' => '1-800-663-7793',
                        'email' => 'service@puma.com',
                        'address' => 'Puma North America, 2200 East Rodeo Road, Los Angeles, CA 90032'
                    ],
                    [
                        'id' => 2,
                        'title' => 'Puma RS-X',
                        'price' => 399.99,
                        'site_name' => 'Puma',
                        'img' => 'https://artwalk.vtexassets.com/arquivos/ids/436443/39430-2-003-1.jpg?v=638277210260500000',
                        'rating' => 4.5,
                        'link' => 'https://www.puma.com',
                        'contact' => '1-800-663-7793',
                        'email' => 'service@puma.com',
                        'address' => 'Puma North America, 2200 East Rodeo Road, Los Angeles, CA 90032'
                    ]
                ];
                response($products);
                break;

            case 'POST':
                // Lógica para criar um produto
                $inputData = json_decode(file_get_contents('php://input'), true);
                if (!isset($inputData['title'], $inputData['price'])) {
                    response(['message' => 'Title and price are required'], 400);
                    break;
                }
                $newProduct = [
                    'id' => rand(1000, 9999),
                    'title' => $inputData['title'],
                    'price' => $inputData['price'],
                    'site_name' => $inputData['site_name'] ?? 'Unknown',
                    'img' => $inputData['img'] ?? '',
                    'rating' => $inputData['rating'] ?? 0,
                    'link' => $inputData['link'] ?? '',
                    'contact' => $inputData['contact'] ?? '',
                    'email' => $inputData['email'] ?? '',
                    'address' => $inputData['address'] ?? ''
                ];
                response(['message' => 'Product created', 'product' => $newProduct], 201);
                break;

            default:
                response(['message' => 'Method not allowed'], 405);
                break;
        }
        break;

    default:
        response(['message' => 'Route not found'], 404);
        break;
}
