<?php
// routes/api.php

require_once '../controllers/ProductController.php';

$controller = new ProductController();

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$method = $_SERVER['REQUEST_METHOD'];

header("Content-Type: application/json");

if ($uri == '/products' && $method == 'GET') {
    $controller->index();
} elseif ($uri == '/products' && $method == 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);
    $controller->store($data);
} else {
    echo json_encode(["message" => "Route not found"]);
}
